function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 266);

T = World_Economy_Cartel_dAC.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(229) = T(36)+T(45)+params(21)*y(109)*exp(y(31))*params(6)*params(5)*params(5)*exp(params(5)*y(35));
T(230) = getPowerDeriv(T(9),T(10),3);
T(231) = T(138)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3),2);
T(232) = T(5)*T(231);
T(233) = T(130)+T(129)+exp(y(40))*(T(128)+exp(y(40))*exp(y(40))*getPowerDeriv(exp(y(40)),T(11),3));
T(234) = y(61)*(-(T(78)*T(19)*T(16)*exp(T(1)*y(47))*(1-params(11))*params(3)*T(130)+T(5)*T(19)*T(80)*exp(T(1)*y(47))*(1-params(11))*params(3)*T(130)))+y(60)*(-(T(82)*T(3)*T(16)*exp(T(1)*y(47))*(1-params(11))*(1-params(3))*T(130)+T(17)*T(3)*T(80)*exp(T(1)*y(47))*(1-params(11))*(1-params(3))*T(130)));
T(235) = y(61)*(-(T(5)*T(19)*T(16)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(47))*T(130)))+y(60)*(-(T(17)*T(3)*T(16)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(47))*T(130)));
T(236) = T(141)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,2);
T(237) = y(61)*(-(T(5)*(T(16)*T(49)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(47))*T(141)+T(19)*T(49)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(47))*T(79)*T(139))))+y(60)*(-(T(17)*(T(16)*T(49)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(47))*T(138)+T(3)*T(49)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(47))*T(79)*T(139))));
T(238) = y(61)*(-(T(78)*T(19)*T(50)*T(80)+T(19)*T(16)*T(50)*T(176)+T(78)*T(19)*T(50)*T(80)+T(5)*T(19)*T(50)*T(177)))+y(60)*(-(T(82)*T(3)*T(51)*T(80)+T(17)*T(3)*T(51)*T(177)+T(82)*T(3)*T(51)*T(80)+T(3)*T(16)*T(51)*T(181)));
T(239) = y(61)*(-(T(78)*T(19)*T(16)*T(49)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(47))+T(5)*T(19)*T(80)*T(49)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(47))))+y(60)*(-(T(17)*T(3)*T(80)*T(49)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(47))+T(82)*T(3)*T(16)*T(49)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(47))));
T(240) = y(61)*(-(T(5)*T(19)*T(16)*T(49)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(47))))+y(60)*(-(T(17)*T(3)*T(16)*T(49)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(47))));
T(241) = getPowerDeriv(T(60),T(10),3);
T(242) = T(135)+exp(y(98))*exp(y(98))*getPowerDeriv(exp(y(98)),T(11),2);
T(243) = (1-params(11))*(1-params(3))*exp(T(1)*y(103))*T(242);
T(244) = T(154)+T(153)+T(20)*(T(152)+T(20)*T(20)*getPowerDeriv(T(20),params(3),3));
T(245) = getPowerDeriv(T(56),T(1),3);
T(246) = getPowerDeriv(T(56),T(13),3);
T(247) = T(53)*T(154)*T(53)*T(54)*T(157)+T(66)*T(53)*T(244)+T(53)*T(154)*T(53)*T(54)*T(157)+T(53)*T(54)*(T(53)*T(154)*T(157)+T(53)*T(54)*T(53)*T(54)*T(246));
T(248) = T(53)*T(154)*T(157)*T(55)*T(193)+T(66)*T(154)*T(193)+T(53)*T(54)*T(157)*T(54)*T(193)+T(53)*T(54)*(T(157)*T(54)*T(193)+T(53)*T(54)*T(55)*T(193)*T(246));
T(249) = T(193)+exp(y(99))*exp(y(99))*getPowerDeriv(exp(y(99)),1-params(3),2);
T(250) = T(54)*T(193)*T(157)*T(55)*T(193)+T(66)*T(54)*T(249)+T(54)*T(193)*T(157)*T(55)*T(193)+T(53)*T(54)*(T(55)*T(193)*T(55)*T(193)*T(246)+T(157)*T(55)*T(249));
T(251) = getPowerDeriv(T(6),T(13),3);
T(252) = T(78)*T(138)*T(139)*T(144)+T(79)*T(78)*T(231)+T(78)*T(138)*T(139)*T(144)+T(3)*T(78)*(T(144)*T(232)+T(139)*T(139)*T(251));
T(253) = getPowerDeriv(T(6),T(1),3);
T(254) = getPowerDeriv(T(25),(-params(14)),2);
T(255) = T(164)*(-(params(9)*(T(162)+exp(y(14))*exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),2))/(1+params(8))))+T(163)*T(163)*T(254);
T(256) = T(26)*exp(y(15))*T(164)+T(26)*exp(y(15))*T(164);
T(257) = getPowerDeriv(T(23),(-params(14)),3);
T(258) = T(171)*T(73)*T(172)+T(74)*(-(params(9)*(T(170)+T(169)+T(4)*(T(168)+T(4)*T(4)*getPowerDeriv(T(4),1+params(8),3)))/(1+params(8))))+T(171)*T(73)*T(172)+T(73)*(T(171)*T(172)+T(73)*T(73)*T(257));
T(259) = T(176)+T(175)+T(4)*(T(174)+T(4)*T(4)*getPowerDeriv(T(4),1-params(3),3));
T(260) = T(3)*T(176)*T(3)*T(78)*T(144)+T(79)*T(3)*T(259)+T(3)*T(176)*T(3)*T(78)*T(144)+T(3)*T(78)*(T(144)*T(3)*T(176)+T(3)*T(78)*T(3)*T(78)*T(251));
T(261) = getPowerDeriv(T(86),(-params(14)),2);
T(262) = params(1)*(T(199)*(-(params(9)*(T(197)+exp(y(99))*exp(y(99))*getPowerDeriv(exp(y(99)),1+params(8),2))/(1+params(8))))+T(198)*T(198)*T(261));
T(263) = y(61)*(-(T(78)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(47))+T(5)*T(19)*T(80)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(47))));
T(264) = y(60)*(-(T(82)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(47))+T(17)*T(3)*T(80)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(47))));
T(265) = T(206)+exp(y(43))*exp(y(43))*T(172)+exp(y(43))*(exp(y(43))*T(172)+exp(y(43))*exp(y(43))*T(257));
T(266) = getPowerDeriv(exp(y(55)-y(48)),params(5)-1,3);

end
